
#version 430

layout (location = 0) in vec3 position;
layout (location = 1) in vec4 color;

layout (location = 0) out vec4 fcolor;


uniform mat4 projection;
uniform mat4 view;

layout(binding = 0, rgba32f) uniform readonly restrict image2D inputTex;


void main()

{
	
	mat4 MVP;
	mat4 MV;
		
	MVP[0] = vec4(imageLoad(inputTex, ivec2(0, 0)));
  MVP[1] = vec4(imageLoad(inputTex, ivec2(1, 0)));
  MVP[2] = vec4(imageLoad(inputTex, ivec2(2, 0)));
  MVP[3] = vec4(imageLoad(inputTex, ivec2(3, 0)));

	MV[0] = vec4(imageLoad(inputTex, ivec2(4, 0)));
  MV[1] = vec4(imageLoad(inputTex, ivec2(5, 0)));
  MV[2] = vec4(imageLoad(inputTex, ivec2(6, 0)));
  MV[3] = vec4(imageLoad(inputTex, ivec2(7, 0)));


	vec4 viewPos = vec4(position, 1.0f);
	
	gl_Position = projection * MV * viewPos;

	fcolor = color;

}